//
//  BiometricOnlineViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class BiometricOnlineViewController: BaseViewController {

    @IBOutlet weak var subtitleText: UILabel!
    private var biokey: String!
    
    @IBOutlet weak var resultContainerView: UIView!
    @IBOutlet weak var otpText: UILabel!
    @IBOutlet weak var generateButton: UIButton!

    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "Online Biometrics OTP"
        self.resultContainerView.isHidden = true
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        biokey = checkIfBiokeyExists(pinMode: IW_PINMODE_BIO, alias: nil)
        startBiometricOtpGeneration()
    }
    
    func finalizeBiometricOtpGeneration() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.finalizeOnlineOTPGenerationProcess(pin: self.biokey, isBiokey: true)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.otpText.text = InweboService.sharedInstance.getOnlineOtpAnswer()
                    self.resultContainerView.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    func startBiometricOtpGeneration() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startOnlineOTPGenerationProcess()
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.generateButton.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }
    }
    
    @IBAction func generateTouched(_ sender: Any) {
        
        let pinMode = InweboService.sharedInstance.getPinMode()
        
        if pinMode == IW_PINMODE_NONE {
            finalizeBiometricOtpGeneration()
        } else if pinMode & IW_PINMODE_BIO != 0 {
            finalizeBiometricOtpGeneration()
        } else {
            self.showAlert(title: "Biokey", message: "The biometric option is not authorized in your account settings", button1: (name: "Ok", action: {
                _ in self.navigationController?.popViewController(animated: true)
            }), button2: nil)
        }
    }
    
    @IBAction func copyTouched(_ sender: Any) {
        UIPasteboard.general.string = otpText.text
    }

}
